require( "scripts/style.lua" )

-- Start the Comic Screen Timer
StartComicScreenTimer();

TableInfoFont = {
  standardFont,
  30,
  BlackColor
};

LeftButtonGraphics = {
	"buttons/arrowleft_up.png",
	"buttons/arrowleft_down.png",
	"buttons/arrowleft_over.png"
};

RightButtonGraphics = {
	"buttons/arrowright_up.png",
	"buttons/arrowright_down.png",
	"buttons/arrowright_over.png"
};

MakeDialog
{
	Bitmap
	{ 
		image="images/ComicPanel3Sketch.jpg",	
		x=kCenter,
		y=kCenter,
		
		-- button to leave comic
		Button{
			x=680,
			y=550,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name = "next",
			type = kPush,
			label = "done",
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
			command=
				function()
					-- Pause the timer
					PauseComicScreenTimer();
					PopModal();
					DoModal("scripts/game_over.lua");
					--DoModal("scripts/album.lua");
				end
		};		
		
		
		-- Another perfect match...
		Text
		{
			font = { comicFont, 20, BlackColor };
			x=65, y=35,
			w=156,h=51,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_3_1_a",
		};
		
		-- That was the most...
		Text
		{
			font = { comicFont, 18, BlackColor };
			x=453, y=47,
			w=249,h=61,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_3_1_b",
		};
		
		-- Really? That was my...
		Text
		{
			font = { comicFont, 18, BlackColor };
			x=541, y=113,
			w=200,h=61,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_3_1_c",
		};
		
		-- Well, actually...
		Text
		{
			font = { comicFont, 20, BlackColor };
			x=268, y=368,
			w=138,h=35,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_3_1_d",
		};
		
		-- We should team up...
		Text
		{
			font = { comicFont, 18, BlackColor };
			x=453, y=339,
			w=133,h=43,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_3_1_e",
		};
		
		-- Thanks. I'll think about...
		Text
		{
			font = { comicFont, 14, BlackColor };
			x=589, y=341,
			w=131,h=59,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_3_1_f",
		};
	}
}

PlayComicMusic();



